<?php
require_once 'includes/connection.php';
include("includes/function.php");
include("includes/data.php");
include("alert/alert.php");
include("smtp_email.php");
$settings = getById("tbl_settings", "1");

$imagepath = getBaseUrl();

$response = array();
$key_get = $_GET['key'];
$limit = $_GET['limit'];
$getByCat = $_GET['getByCat'];
$slider = $_GET['slider'];
$byid = $_GET['byid'];
$get_latest = $_GET['latest'];
$get_type = $_GET['type'];
$getByUser = $_GET['getByUser'];

$target_dir = "images/profile/";
$newsTarget_dir = "images/";


$headers = apache_request_headers();
$get_pcode = $headers['Pcode'];
$get_pname = $headers['Pname'];

if (!isset($get_pcode) && !isset($get_pname)) {
$get_pcode = $headers['pcode'];
$get_pname = $headers['pname'];
}

if (!isset($get_pcode) && !isset($get_pname)) {
    header("WWW-Authenticate: Basic realme=\"Private Area\"");
    header("HTTP/1.0 401 Unauthorized");
    $response['error'] = true;
    $response['message'] = 'Invalid Purchase Code or Package Name';
} else if ($get_pcode == PURCHASE_CODE && $get_pname == PACKAGE_NAME) {
    if ($key_get == $settings['api_key']) {

        if (isset($_GET['apicall'])) {

            switch ($_GET['apicall']) {
                case 'register':
                    //checking the parameters required are available or not 
                    if (isTheseParametersAvailable(array('user_type', 'name', 'email', 'phone', 'password', 'auth_id'))) {

                        //getting the values 
                        $role = "User";
                        $user_type = $_POST['user_type'];
                        $name = $_POST['name'];
                        $email = $_POST['email'];
                        $phone = $_POST['phone'];
                        $password = md5($_POST['password']);
                        $auth_id = $_POST['auth_id'];
                        $registered_on = strtotime(date('d-m-Y h:i:s A'));

                        //checking if the user is already exist with this email
                        //as the email should be unique for every user 
                        if ($user_type == "google" or $user_type == "facebook") {
                            $stmt = $mysqli->prepare("SELECT user_id, user_type, name, email, phone, auth_id, registered_on FROM tbl_users WHERE email = ? OR auth_id = ?");
                            $stmt->bind_param("ss", $email, $auth_id);
                        } else {
                            $stmt = $mysqli->prepare("SELECT user_id, user_type, name, email, phone, auth_id, registered_on FROM tbl_users WHERE email = ? AND role = ? ");
                            $stmt->bind_param("ss", $email, $role);
                        }

                        $stmt->execute();
                        $stmt->store_result();

                        //if the user already exist in the database 
                        if ($stmt->num_rows > 0) {
                            $stmt->bind_result($user_id, $user_type, $name, $email, $phone, $auth_id, $registered_on);
                            $stmt->fetch();
                            $user = array(
                                'user_id' => $user_id,
                                'user_type' => $user_type,
                                'name' => $name,
                                'email' => $email,
                                'phone' => $phone,
                                'auth_id' => $auth_id,
                                'registered_on' => date('d-m-Y H:i:s', $registered_on)
                            );
                            $response['error'] = true;
                            $response['message'] = 'This email already registered';
                            $response['user'] = $user;
                            if ($user_type == "google" or $user_type == "facebook") {
                                $sql = "UPDATE tbl_users SET `auth_id`='" . $_POST['auth_id'] . "' WHERE `user_id`='" . $user['user_id'] . "'";
                                mysqli_query($mysqli, $sql);
                            }
                            $stmt->close();
                        } else {

                            //if user is new creating an insert query 
                            $stmt = $mysqli->prepare("INSERT INTO tbl_users (role, user_type, name, email, phone, password, auth_id, registered_on) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
                            $stmt->bind_param("ssssssss", $role, $user_type, $name, $email, $phone, $password, $auth_id, $registered_on);

                            //if the user is successfully added to the database 
                            if ($stmt->execute()) {

                                 //fetching the user back 
                                $stmt = $mysqli->prepare("SELECT user_id, user_type, name, email, img_url, phone, auth_id, registered_on FROM tbl_users WHERE email = ?");
                                $stmt->bind_param("s", $email);
                                $stmt->execute();
                                $stmt->bind_result($user_id, $user_type, $name, $email, $img_url, $phone, $auth_id, $registered_on);
                                $stmt->fetch();
                                
                                $social_img =  $imagepath . $img_url;
                                if (strpos($social_img, "googleusercontent")) {
                                $social_img = $img_url;
                                }

                                $user = array(
                                    'user_id' => $user_id,
                                    'user_type' => $user_type,
                                    'name' => $name,
                                    'email' => $email,
                                    'img_url' => $social_img,
                                    'phone' => $phone,
                                    'auth_id' => $auth_id,
                                    'registered_on' => date('d-m-Y H:i:s', $registered_on)
                                );


                                $to = $user['email'];
                                $recipient_name = $user['name'];
                                // subject
                                $subject = str_replace('###', APP_NAME, $alert_msg['register_mail_lbl']);
                                $message = '<!doctype html>
<html lang="en-US">

<body marginheight="0" topmargin="0" marginwidth="0" style="margin: 0px; background-color: #f5f5f5;" leftmargin="0">
     <table cellspacing="0" border="0" cellpadding="0" width="100%" bgcolor="#f5f5f5">
        <tr>
            <td>
                <table style="background-color: #f5f5f5; max-width:670px;  margin:0 auto;" width="100%" border="0"
                    align="center" cellpadding="0" cellspacing="0">
                    <tr>
                        <td style="height:80px;">&nbsp;</td>
                    </tr>
                    <tr>
                        <td style="text-align:center;">
                            <img width="120px" src="' . $imagepath . "images/" . APP_LOGO . '" title="logo" alt="logo">
                        </td>
                    </tr>
                    <tr>
                        <td style="height:20px;">&nbsp;</td>
                    </tr>
                    <tr>
                        <td>
                            <table width="95%" border="0" align="center" cellpadding="0" cellspacing="0"
                                style="max-width:670px;background:#fff; border-radius:3px; text-align:center;-webkit-box-shadow:0 6px 18px 0 rgba(0,0,0,.06);-moz-box-shadow:0 6px 18px 0 rgba(0,0,0,.06);box-shadow:0 6px 18px 0 rgba(0,0,0,.06);">
                                <tr>
                                    <td style="height:40px;">&nbsp;</td>
                                </tr>
                                <tr>
                                    <td style="padding:0 35px;">
                            		<img width="70" src="' . $imagepath . "assets/img/done.png" . '"  style="margin-bottom:10px">
                                        <h1 style="color:#1e1e2d; font-weight:500; margin:0;font-size:23px;">' . $alert_msg['thank_you_joining'] . '</h1>
                                        <br>
                                        <br>
					<span style="display:inline-block; vertical-align:middle; margin:0 0 10px; border-bottom:1px solid #cecece; width:100px;"></span>
                                        <br>
                                        <br>
					<h3 style="color:#6c6c6c; font-weight:500; margin-top:10px;font-size:14px;">' . $alert_msg['dear_lbl'] . ' ' . $user['name'] . ' , ' . $alert_msg['normal_register_msg'] . '</h1> 
                                        
                                        <br>
                                        <br>
					<span style="display:inline-block; vertical-align:middle; margin:0 0 10px; border-bottom:1px solid #cecece; width:100px;"></span>
                                        <br>
                                        <br>
					<p style="font-size:14px; color:rgba(69, 80, 86, 0.7411764705882353); line-height:18px; margin:0 0 0;">' . $alert_msg['email_copyright'] . ' ' . APP_NAME . '.</p>
					
                                    </td>
                                </tr>
                                <tr>
                                    <td style="height:40px;">&nbsp;</td>
                                </tr>
                            </table>
                        </td>
                    <tr>
                        <td style="height:20px;">&nbsp;</td>
                    </tr>
                    
                    <tr>
                        <td style="height:80px;">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>

</body>

</html>';

                                send_email($to, $recipient_name, $subject, $message);
                                //adding the user data in response 
                                $response['error'] = false;
                                $response['message'] = 'User registered successfully';
                                $response['user'] = $user;
                                $stmt->close();
                            } else {
                                $response['error'] = true;
                                $response['message'] = 'Something Went Wrong';
                                $response['error_data'] = $stmt->error;
                            }   
                        }
                    } else {
                        $response['error'] = true;
                        $response['message'] = 'required parameters are not available';
                    }

                    break;

                case 'doSocialLogin':
                    //checking the parameters required are available or not 
                    if (isTheseParametersAvailable(array('user_type', 'name', 'email', 'auth_id'))) {

                        //getting the values 
                        $role = "User";
                        $user_type = $_POST['user_type'];
                        $name = $_POST['name'];
                        $email = $_POST['email'];
                        $img_url = $_POST['img_url'];
                        $auth_id = $_POST['auth_id'];
                        $registered_on = strtotime(date('d-m-Y h:i:s A'));

                        //checking if the user is already exist with this email
                        //as the email should be unique for every user 
                        $stmt = $mysqli->prepare("SELECT user_id, user_type, name, email, img_url, phone, auth_id, registered_on, status FROM tbl_users WHERE email = ? AND auth_id = ? AND user_type = ?");
                        
                        $stmt->bind_param("sss", $email, $auth_id, $user_type);

                        $stmt->execute();
                        $stmt->store_result();

                        //if the user already exist in the database 
                        if ($stmt->num_rows > 0) {
                            $stmt->bind_result($user_id, $user_type, $name, $email, $img_url, $phone, $auth_id, $registered_on, $status);
                            $stmt->fetch();
                            $fav_query = "SELECT post_id FROM tbl_favorites WHERE user_id = $user_id";
                            $fav_result = $mysqli->query($fav_query);
                            $fav_ids = array();
                            while ($row = $fav_result->fetch_array()) {
                                $fav_ids[] = $row['post_id'];
                            }
                            
                            $user = array(
                                'user_id' => $user_id,
                                'user_type' => $user_type,
                                'name' => $name,
                                'email' => $email,
                                'img_url' => $img_url,
                                'phone' => $phone,
                                'auth_id' => $auth_id,
                                'registered_on' => date('d-m-Y H:i:s', $registered_on),
                                'status' => $status,
                                'fav_ids' => ',' . implode(",", $fav_ids) . ','
                            );

                            if ($user['status'] == 1) {
                                $response['error'] = false;
                                $response['message'] = 'Login Successfull';
                                $response['user'] = array($user);
                                $sql = "UPDATE tbl_users SET `auth_id`='" . $_POST['auth_id'] . "' WHERE `user_id`='" . $user['user_id'] . "'";
                                mysqli_query($mysqli, $sql);
                            } else {
                                $response['error'] = true;
                                $response['message'] = 'Your account is suspended, please contact support team.';
                            }
                            $stmt->close();
                        } else {

                            //if user is new creating an insert query 
                            $stmt = $mysqli->prepare("INSERT INTO tbl_users (role, user_type, name, email, img_url, auth_id, registered_on) VALUES (?, ?, ?, ?, ?, ?, ?)");
                            $stmt->bind_param("sssssss", $role, $user_type, $name, $email, $img_url, $auth_id, $registered_on);

                            //if the user is successfully added to the database 
                            if ($stmt->execute()) {

                                //fetching the user back 
                                $stmt = $mysqli->prepare("SELECT user_id, user_type, name, email, img_url, phone, auth_id, registered_on FROM tbl_users WHERE email = ?");
                                $stmt->bind_param("s", $email);
                                $stmt->execute();
                                $stmt->bind_result($user_id, $user_type, $name, $email, $img_url, $phone, $auth_id, $registered_on);
                                $stmt->fetch();

                                $user = array(
                                    'user_id' => $user_id,
                                    'user_type' => $user_type,
                                    'name' => $name,
                                    'email' => $email,
                                    'img_url' => $img_url,
                                    'phone' => $phone,
                                    'auth_id' => $auth_id,
                                    'registered_on' => date('d-m-Y H:i:s', $registered_on)
                                );

                                $stmt->close();

                                $to = $user['email'];
                                $recipient_name = $user['name'];
                                // subject
                                $subject = str_replace('###', APP_NAME, $alert_msg['register_mail_lbl']);
                                $message = '<!doctype html>
<html lang="en-US">

<body marginheight="0" topmargin="0" marginwidth="0" style="margin: 0px; background-color: #f5f5f5;" leftmargin="0">
     <table cellspacing="0" border="0" cellpadding="0" width="100%" bgcolor="#f5f5f5">
        <tr>
            <td>
                <table style="background-color: #f5f5f5; max-width:670px;  margin:0 auto;" width="100%" border="0"
                    align="center" cellpadding="0" cellspacing="0">
                    <tr>
                        <td style="height:80px;">&nbsp;</td>
                    </tr>
                    <tr>
                        <td style="text-align:center;">
                            <img width="120px" src="' . $imagepath . "images/" . APP_LOGO . '" title="logo" alt="logo">
                        </td>
                    </tr>
                    <tr>
                        <td style="height:20px;">&nbsp;</td>
                    </tr>
                    <tr>
                        <td>
                            <table width="95%" border="0" align="center" cellpadding="0" cellspacing="0"
                                style="max-width:670px;background:#fff; border-radius:3px; text-align:center;-webkit-box-shadow:0 6px 18px 0 rgba(0,0,0,.06);-moz-box-shadow:0 6px 18px 0 rgba(0,0,0,.06);box-shadow:0 6px 18px 0 rgba(0,0,0,.06);">
                                <tr>
                                    <td style="height:40px;">&nbsp;</td>
                                </tr>
                                <tr>
                                    <td style="padding:0 35px;">
                            		<img width="70" src="' . $imagepath . "assets/img/done.png" . '"  style="margin-bottom:10px">
                                        <h1 style="color:#1e1e2d; font-weight:500; margin:0;font-size:23px;">' . $alert_msg['thank_you_joining'] . '</h1>
                                        <br>
                                        <br>
					<span style="display:inline-block; vertical-align:middle; margin:0 0 10px; border-bottom:1px solid #cecece; width:100px;"></span>
                                        <br>
                                        <br>
					<h3 style="color:#6c6c6c; font-weight:500; margin-top:10px;font-size:14px;">' . $alert_msg['dear_lbl'] . ' ' . $user['name'] . ' , ' . $alert_msg['normal_register_msg'] . '</h1> 
                                        
                                        <br>
                                        <br>
					<span style="display:inline-block; vertical-align:middle; margin:0 0 10px; border-bottom:1px solid #cecece; width:100px;"></span>
                                        <br>
                                        <br>
					<p style="font-size:14px; color:rgba(69, 80, 86, 0.7411764705882353); line-height:18px; margin:0 0 0;">' . $alert_msg['email_copyright'] . ' ' . APP_NAME . '.</p>
					
                                    </td>
                                </tr>
                                <tr>
                                    <td style="height:40px;">&nbsp;</td>
                                </tr>
                            </table>
                        </td>
                    <tr>
                        <td style="height:20px;">&nbsp;</td>
                    </tr>
                    
                    <tr>
                        <td style="height:80px;">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>

</body>

</html>';

                                send_email($to, $recipient_name, $subject, $message);
                                //adding the user data in response 
                                $response['error'] = false;
                                $response['message'] = 'Login Successfull';
                                $response['user'] = array($user);
                            }
                        }
                    } else {
                        $response['error'] = true;
                        $response['message'] = 'Something went wrong!!!';
                    }

                    break;

                case 'login':
                    //for login we need the username and password 
                    if (isTheseParametersAvailable(array('email', 'password'))) {
                        //getting values 
                        $email = $_POST['email'];
                        $password = md5($_POST['password']);

                        //creating the query 
                        $stmt = $mysqli->prepare("SELECT user_id, name, email, phone, img_url, registered_on, status FROM tbl_users WHERE email = ? AND password = ?");
                        $stmt->bind_param("ss", $email, $password);

                        $stmt->execute();

                        $stmt->store_result();

                        //if the user exist with given credentials 
                        if ($stmt->num_rows > 0) {

                            $stmt->bind_result($user_id, $name, $email, $img_url, $phone, $registered_on, $status);
                            $stmt->fetch();
                            $fav_query = "SELECT post_id FROM tbl_favorites WHERE user_id = $user_id";
                            $fav_result = $mysqli->query($fav_query);
                            $fav_ids = array();
                            while ($row = $fav_result->fetch_array()) {
                                $fav_ids[] = $row['post_id'];
                            }

                            $user = array(
                                'user_id' => $user_id,
                                'name' => $name,
                                'email' => $email,
                                'phone' => $phone,
                                'img_url' => $imagepath.$img_url,
                                'status' => $status,
                                'registered_on' => time_ago_full(date('d-m-Y H:i:s', $registered_on)),
                                'fav_ids' => ',' . implode(",", $fav_ids) . ','
                            );

                            if ($user['status'] == 1) {
                                $response['error'] = false;
                                $response['message'] = 'Login Successfull';
                                $response['user'] = array($user);
                                $sql = "UPDATE tbl_users SET `auth_id`='" . $_POST['auth_id'] . "' WHERE `user_id`='" . $user['user_id'] . "'";
                                mysqli_query($mysqli, $sql);
                            } else {
                                $response['error'] = true;
                                $response['message'] = 'Your account is suspended, please contact support team.';
                            }
                        } else {
                            //if the user not found 
                            $response['error'] = true;
                            $response['message'] = 'Invalid Email or Password';
                        }
                    }
                    break;

                case 'reset':
                    $email = $_POST['email'];
                    $phone = $_POST['phone'];

                    $qry = "SELECT * FROM tbl_users WHERE email = '$email' AND phone = '$phone' AND `user_id` <> 0";
                    $result = mysqli_query($mysqli, $qry);
                    $row = mysqli_fetch_assoc($result);

                    if ($row['email'] != "" and $row['phone'] != "") {
                        $password = generateRandomPassword(7);

                        $new_password = md5($password);

                        $to = $row['email'];
                        $recipient_name = $row['name'];
                        // subject
                        $subject = str_replace('###', APP_NAME, $alert_msg['forgot_password_sub_lbl']);

                        $message = '<!doctype html>
<html lang="en-US">

<body marginheight="0" topmargin="0" marginwidth="0" style="margin: 0px; background-color: #f5f5f5;" leftmargin="0">
     <table cellspacing="0" border="0" cellpadding="0" width="100%" bgcolor="#f5f5f5">
        <tr>
            <td>
                <table style="background-color: #f5f5f5; max-width:670px;  margin:0 auto;" width="100%" border="0"
                    align="center" cellpadding="0" cellspacing="0">
                    <tr>
                        <td style="height:80px;">&nbsp;</td>
                    </tr>
                    <tr>
                        <td style="text-align:center;">
                            <img width="120px" src="' . $imagepath . "images/" . APP_LOGO . '" title="logo" alt="logo">
                        </td>
                    </tr>
                    <tr>
                        <td style="height:20px;">&nbsp;</td>
                    </tr>
                    <tr>
                        <td>
                            <table width="95%" border="0" align="center" cellpadding="0" cellspacing="0"
                                style="max-width:670px;background:#fff; border-radius:3px; text-align:center;-webkit-box-shadow:0 6px 18px 0 rgba(0,0,0,.06);-moz-box-shadow:0 6px 18px 0 rgba(0,0,0,.06);box-shadow:0 6px 18px 0 rgba(0,0,0,.06);">
                                <tr>
                                    <td style="height:40px;">&nbsp;</td>
                                </tr>
                                <tr>
                                    <td style="padding:0 35px;">
                                        <h1 style="color:#1e1e2d; font-weight:500; margin:0;font-size:23px;">Forgot Your Password ?</h1>
                                        <h3 style="color:#6c6c6c; font-weight:500; margin-top:10px;font-size:14px;">' . $alert_msg['dear_lbl'] . ' ' . $row['name'] . ' , ' . $alert_msg['request_received'] . '</h1> 
                                        <br>
                                        <br>
					<span style="display:inline-block; vertical-align:middle; margin:0 0 10px; border-bottom:1px solid #cecece; width:100px;"></span>
                                        <br>
                                        <br>
                                        <p style="color:#455056; font-size:20px;line-height:24px; margin:0;">
                                            ' . $alert_msg['your_password_lbl'] . '
					<h3 style="color:#1e1e2d; font-weight:500; margin-top:10px;font-size:25px;><span style="font-weight:400;">' . $password . '</span></h3>
                                        </p>
                                        <br>
					<span style="display:inline-block; vertical-align:middle; margin:0 0 10px; border-bottom:1px solid #cecece; width:100px;"></span>
                                        <br>
					<p style="color:#455056; font-size:18px;line-height:20px; margin:0;">
                                            ' . $alert_msg['thank_you_lbl'] . ' ' . APP_NAME . '</p>
					
                                    </td>
                                </tr>
                                <tr>
                                    <td style="height:40px;">&nbsp;</td>
                                </tr>
                            </table>
                        </td>
                    <tr>
                        <td style="height:20px;">&nbsp;</td>
                    </tr>
                    <tr>
                        <td style="text-align:center;">
                            <p style="font-size:14px; color:rgba(69, 80, 86, 0.7411764705882353); line-height:18px; margin:0 0 0;">' . $alert_msg['email_copyright'] . ' ' . APP_NAME . '.</p>
                        </td>
                    </tr>
                    <tr>
                        <td style="height:80px;">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>

</body>

</html>';

                        send_email($to, $recipient_name, $subject, $message);

                        $sql = "UPDATE tbl_users SET `password`='$new_password' WHERE `user_id`='" . $row['user_id'] . "'";
                        mysqli_query($mysqli, $sql);

                        $response['error'] = false;
                        $response['message'] = $alert_msg['password_reset_success'];
                    } else {

                        $response['error'] = true;
                        $response['message'] = $alert_msg['password_reset_fail'];
                    }


                    break;

                case 'updateProfile':
                    //error message and error flag
                    $message = 'Field ';
                    $is_error = false;

                    //validating the request to check if all the required parameters are available or not 
                    if (!isset($_POST['name'])) {
                        $message .= "name";
                        $is_error = true;
                    }

                    if (!isset($_POST['email'])) {
                        $message .= "email";
                        $is_error = true;
                    }

                    if (!isset($_POST['email'])) {
                        $message .= "email";
                        $is_error = true;
                    }

                    if (!isset($_POST['phone'])) {
                        $message .= "phone";
                        $is_error = true;
                    }
                    //in case we have an error in validation, displaying the error message 
                    if ($is_error) {
                        $response['error'] = true;
                        $response['message'] = $message . " is required.";
                    } else {

                        if (isset($_FILES['img_url']['name'])) {
                            $file = $_FILES['img_url']['tmp_name'];
                            $sourceProperties = getimagesize($file);
                            $ext = pathinfo($_FILES['img_url']['name'], PATHINFO_EXTENSION);
                            $imageType = $sourceProperties[2];
                            $fileNewName = "profile_" . $_POST['user_id'];
                            $folderPath = $target_dir;
                            $uploadedFile = $target_dir . $fileNewName . "." . $ext;


                            switch ($imageType) {

                                case IMAGETYPE_PNG:
                                    $imageResourceId = imagecreatefrompng($file);
                                    $targetLayer = imageResize($imageResourceId, $sourceProperties[0], $sourceProperties[1]);
                                    imagepng($targetLayer, $folderPath . $fileNewName . "." . $ext);
                                    break;


                                case IMAGETYPE_GIF:
                                    $imageResourceId = imagecreatefromgif($file);
                                    $targetLayer = imageResize($imageResourceId, $sourceProperties[0], $sourceProperties[1]);
                                    imagegif($targetLayer, $folderPath . $fileNewName . "." . $ext);
                                    break;

                                case IMAGETYPE_JPEG:
                                    $imageResourceId = imagecreatefromjpeg($file);
                                    $targetLayer = imageResize($imageResourceId, $sourceProperties[0], $sourceProperties[1]);
                                    imagejpeg($targetLayer, $folderPath . $fileNewName . "." . $ext);
                                    break;

                                case IMAGETYPE_JPG:
                                    $imageResourceId = imagecreatefromjpeg($file);
                                    $targetLayer = imageResize($imageResourceId, $sourceProperties[0], $sourceProperties[1]);
                                    imagejpeg($targetLayer, $folderPath . $fileNewName . "." . $ext);
                                    break;

                                default:
                                    echo "Invalid Image type.";
                                    exit;
                                    break;
                            }
                            move_uploaded_file($fileNewName . "." . $ext, $folderPath);
                            $target = $uploadedFile;

                            //saving the uploaded file to the uploads directory in our target file

                            $query = "UPDATE `tbl_users` SET `name` = ?, `email` = ?, `phone` = ?, `img_url` = ? WHERE `user_id` = ?";
                            $stmt = $mysqli->prepare($query);
                            $stmt->bind_param("sssss", $_POST['name'], $_POST['email'], $_POST['phone'], $target, $_POST['user_id']);
                        } else {

                            $query = "UPDATE `tbl_users` SET `name` = ?, `email` = ?, `phone` = ? WHERE `user_id` = ?";
                            $stmt = $mysqli->prepare($query);
                            $stmt->bind_param("ssss", $_POST['name'], $_POST['email'], $_POST['phone'], $_POST['user_id']);
                        }




                        //if it is saved in database successfully
                        if ($stmt->execute()) {
                            $stmt = $mysqli->prepare("SELECT user_id, user_type, name, email, img_url, phone, auth_id, registered_on FROM tbl_users WHERE user_id = ?");
                            $stmt->bind_param("s", $_POST['user_id']);
                            $stmt->execute();
                            $stmt->bind_result($user_id, $user_type, $name, $email, $img_url, $phone, $auth_id, $registered_on);
                            $stmt->fetch();

                            $user = array(
                                'user_id' => $user_id,
                                'user_type' => $user_type,
                                'name' => $name,
                                'email' => $email,
                                'img_url' => $imagepath . $img_url,
                                'phone' => $phone,
                                'auth_id' => $auth_id,
                                'registered_on' => time_ago_full(date('d-m-Y H:i:s', $registered_on))
                            );

                            //displaying success response
                            $response['error'] = false;
                            $response['message'] = 'Profile Updated Successfully';
                            $response['user'] = array($user);
                        } else {
                            //if not saved in database
                            //showing response accordingly
                            $response['error'] = true;
                            $response['message'] = 'Could not update profile, please try again...';
                        }
                        $stmt->close();
                    }
                    break;

                case 'updatePassword':
                    $user_id = $_POST['user_id'];
                    $email = $_POST['email'];
                    $password = $_POST['password'];
                    $qry = "SELECT * FROM tbl_users WHERE email = '$email' AND user_id = '$user_id' AND `user_id` <> 0";
                    $result = mysqli_query($mysqli, $qry);
                    $row = mysqli_fetch_assoc($result);

                    if ($row['user_id'] != "") {

                        $new_password = md5($password);

                        $to = $row['email'];
                        $recipient_name = $row['name'];
                        // subject
                        $subject = str_replace('###', APP_NAME, $alert_msg['password_updated']);

                        $message = '<!doctype html>
<html lang="en-US">

<body marginheight="0" topmargin="0" marginwidth="0" style="margin: 0px; background-color: #f5f5f5;" leftmargin="0">
     <table cellspacing="0" border="0" cellpadding="0" width="100%" bgcolor="#f5f5f5">
        <tr>
            <td>
                <table style="background-color: #f5f5f5; max-width:670px;  margin:0 auto;" width="100%" border="0"
                    align="center" cellpadding="0" cellspacing="0">
                    <tr>
                        <td style="height:80px;">&nbsp;</td>
                    </tr>
                    <tr>
                        <td style="text-align:center;">
                            <img width="120px" src="' . $imagepath . "images/" . APP_LOGO . '" title="logo" alt="logo">
                        </td>
                    </tr>
                    <tr>
                        <td style="height:20px;">&nbsp;</td>
                    </tr>
                    <tr>
                        <td>
                            <table width="95%" border="0" align="center" cellpadding="0" cellspacing="0"
                                style="max-width:670px;background:#fff; border-radius:3px; text-align:center;-webkit-box-shadow:0 6px 18px 0 rgba(0,0,0,.06);-moz-box-shadow:0 6px 18px 0 rgba(0,0,0,.06);box-shadow:0 6px 18px 0 rgba(0,0,0,.06);">
                                <tr>
                                    <td style="height:40px;">&nbsp;</td>
                                </tr>
                                <tr>
                                    <td style="padding:0 35px;">
                            		<img width="70" src="' . $imagepath . "assets/img/done.png" . '"  style="margin-bottom:10px">
                                        <h1 style="color:#1e1e2d; font-weight:500; margin:0;font-size:23px;">' . $alert_msg['password_updated'] . ' </h1>
                                        <h3 style="color:#6c6c6c; font-weight:500; margin-top:10px;font-size:14px;">' . $alert_msg['dear_lbl'] . ' ' . $row['name'] . ' , ' . $alert_msg['password_updated_success'] . '</h1> 
                                        <br>
                                        <br>
					<span style="display:inline-block; vertical-align:middle; margin:0 0 10px; border-bottom:1px solid #cecece; width:100px;"></span>
                                        <br>
					<p style="color:#455056; font-size:18px;line-height:20px; margin:0;">
                                            ' . $alert_msg['thank_you_lbl'] . ' ' . APP_NAME . '</p>
					
                                    </td>
                                </tr>
                                <tr>
                                    <td style="height:40px;">&nbsp;</td>
                                </tr>
                            </table>
                        </td>
                    <tr>
                        <td style="height:20px;">&nbsp;</td>
                    </tr>
                    <tr>
                        <td style="text-align:center;">
                            <p style="font-size:14px; color:rgba(69, 80, 86, 0.7411764705882353); line-height:18px; margin:0 0 0;">' . $alert_msg['email_copyright'] . ' ' . APP_NAME . '.</p>
                        </td>
                    </tr>
                    <tr>
                        <td style="height:80px;">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>

</body>

</html>';

                        send_email($to, $recipient_name, $subject, $message);

                        $sql = "UPDATE tbl_users SET `password`='$new_password' WHERE `user_id`='" . $row['user_id'] . "'";
                        mysqli_query($mysqli, $sql);

                        $response['error'] = false;
                        $response['message'] = $alert_msg['password_updated_success'];
                    } else {

                        $response['error'] = true;
                        $response['message'] = $alert_msg['password_update_fail'];
                    }


                    break;

                case 'category':
                    if (isset($get_latest)) {
                        $query = "SELECT
             cat_id, category_name, category_image FROM tbl_category WHERE status = '1' ORDER BY cat_id DESC LIMIT $get_latest";
                    } else {
                        $query = "SELECT
             cat_id, category_name, category_image FROM tbl_category WHERE status = '1' ORDER BY category_name";
                    }
                    $stmt = $mysqli->prepare($query);
                    $stmt->execute();
                    $stmt->bind_result($cat_id, $category_name, $category_image);

                    while ($stmt->fetch()) {
                        $data = array();
                        $data['cat_id'] = $cat_id;
                        $data['category_name'] = $category_name;
                        $data['category_image'] = $imagepath . 'images/' . $category_image;
                        array_push($response, $data);
                    }

                    break;

                case 'news':
                    $uid = $_GET['uid'];

                    if (($get_type == "latest")) {
                        $query = "SELECT
            id, news_type, cid, uid, category_name, news_title, news, thumbnail, video_url, share, views, (select count(*) from tbl_comments cm where cm.nid = id) as comments, name as posted_by, posted_at, news_status
            FROM tbl_news
            LEFT JOIN tbl_category c
                ON cid = c.cat_id 
            LEFT JOIN tbl_users u
                ON uid = u.user_id 
            WHERE news_status = '1' ORDER BY id DESC LIMIT " . $settings['latest_news_limit'] . " ";
                    } else if (($get_type == "trending")) {
                        $query = "SELECT
            id, news_type, cid, uid, category_name, news_title, news, thumbnail, video_url, share, views, (select count(*) from tbl_comments cm where cm.nid = id) as comments, name as posted_by, posted_at, news_status
            FROM tbl_news
            LEFT JOIN tbl_category c
                ON cid = c.cat_id 
            LEFT JOIN tbl_users u
                ON uid = u.user_id 
            WHERE news_status = '1' ORDER BY views DESC LIMIT " . $settings['trending_news_limit'] . "";
                    } else if (($get_type == "related")) {
                        $query = "SELECT
            id, news_type, cid, uid, category_name, news_title, news, thumbnail, video_url, share, views, (select count(*) from tbl_comments cm where cm.nid = id) as comments, name as posted_by, posted_at, news_status
            FROM tbl_news
            LEFT JOIN tbl_category c
                ON cid = c.cat_id 
            LEFT JOIN tbl_users u
                ON uid = u.user_id 
            WHERE news_status = '1' AND id <> '" . $_GET['post_id'] . "' ORDER BY rand() DESC LIMIT " . $settings['related_news_limit'] . "";
                    } else if ($get_type == "favorites") {
                        $query = "SELECT
            id, news_type, cid, uid, category_name, news_title, news, thumbnail, video_url, share, views, (select count(*) from tbl_comments cm where cm.nid = id) as comments, name as posted_by, posted_at, news_status
            FROM tbl_news
            LEFT JOIN tbl_category c
                ON cid = c.cat_id 
            LEFT JOIN tbl_users u
                ON uid = u.user_id
            LEFT JOIN tbl_favorites f
                ON id = f.post_id
            WHERE f.user_id = $uid AND news_status = '1'";
                    } else if (isset($byid)) {
                        $query = "SELECT
            id, news_type, cid, uid, category_name, news_title, news, thumbnail, video_url, share, views, (select count(*) from tbl_comments cm where cm.nid = id) as comments, name as posted_by, posted_at, news_status
            FROM tbl_news
            LEFT JOIN tbl_category c
                ON cid = c.cat_id 
            LEFT JOIN tbl_users u
                ON uid = u.user_id 
            WHERE FIND_IN_SET(`id`, '$byid') AND news_status = '1'";
                    } else if (isset($getByCat)) {
                        $page_limit = 6;
                        $limit = ($_GET['page'] - 1) * $page_limit;

                        $query = "SELECT
            id, news_type, cid, uid, category_name, news_title, news, thumbnail, video_url, share, views, (select count(*) from tbl_comments cm where cm.nid = id) as comments, name as posted_by, posted_at, news_status
            FROM tbl_news
            LEFT JOIN tbl_category c
                ON cid = c.cat_id 
            LEFT JOIN tbl_users u
                ON uid = u.user_id 
            WHERE c.cat_id = " . $getByCat . " AND news_status = '1' ORDER BY id DESC LIMIT $limit, $page_limit";
                    } else if (($get_type == "user")) {
                        $user_id = $_GET['user_id'];
                        $query = "SELECT
            id, news_type, cid, uid, category_name, news_title, news, thumbnail, video_url, share, views, (select count(*) from tbl_comments cm where cm.nid = id) as comments, name as posted_by, posted_at, news_status
            FROM tbl_news
            LEFT JOIN tbl_category c
                ON cid = c.cat_id 
            LEFT JOIN tbl_users u
                ON uid = u.user_id 
            WHERE c.cat_id = cid AND uid = " . $user_id . " ORDER BY id DESC";
                    } else if (isset($_GET['search'])) {
                        $SearchField = '%' . $_GET['search'] . '%';
                        $query = "SELECT
            id, news_type, cid, uid, category_name, news_title, news, thumbnail, video_url, share, views, (select count(*) from tbl_comments cm where cm.nid = id) as comments, name as posted_by, posted_at, news_status
            FROM tbl_news
            LEFT JOIN tbl_category c
                ON cid = c.cat_id 
            LEFT JOIN tbl_users u
                ON uid = u.user_id 
            WHERE news_title LIKE '" . $SearchField . "' AND news_status = '1' ORDER BY id DESC ";
                    }


                    $sql01 = mysqli_query($mysqli, $query);

                    if (mysqli_num_rows($sql01) > 0) {
                        while ($data = mysqli_fetch_assoc($sql01)) {
                            $row = array();
                            $row['id'] = $data['id'];
                            $row['type'] = $data['news_type'];
                            $row['cid'] = $data['cid'];
                            $row['uid'] = $data['uid'];
                            $row['category_name'] = $data['category_name'];
                            $row['news_title'] = stripslashes($data['news_title']);
                            $row['news'] = stripslashes($data['news']);
                            $row['thumbnail'] = $imagepath . 'images/' . $data['thumbnail'];
                            $row['video_url'] = $data['video_url'];
                            $row['share'] = thousandsNumberFormat($data['share']);
                            $row['views'] = thousandsNumberFormat($data['views']);
                            $row['comments'] = thousandsNumberFormat($data['comments']);
                            $row['posted_by'] = $data['posted_by'];
                            $row['posted_at'] = time_ago_small(date('d-m-Y H:i:s', $data['posted_at']));
                            $row['news_status'] = $data['news_status'];
                            array_push($response, $row);
                        }
                    }
                    break;

                case 'videos':
                    if (($get_type == "latest")) {
                        $query = "SELECT
            id, video_type, cid, category_name, video_title, description, thumbnail, video_url, share, views, (select count(*) from tbl_comments cm where cm.vid = id) as comments, posted_at, video_status
            FROM tbl_videos
            LEFT JOIN tbl_category c
                ON cid = c.cat_id 
            WHERE video_status = '1' ORDER BY id DESC LIMIT " . $settings['latest_videos_limit'] . " ";
                    } else if (($get_type == "related")) {
                        $query = "SELECT
            id, video_type, cid, category_name, video_title, description, thumbnail, video_url, share, views, (select count(*) from tbl_comments cm where cm.vid = id) as comments, posted_at, video_status
            FROM tbl_videos
            LEFT JOIN tbl_category c
                ON cid = c.cat_id 
            WHERE video_status = '1' AND id <> '" . $_GET['post_id'] . "' ORDER BY rand() DESC LIMIT " . $settings['related_videos_limit'] . "";
                    } else if (isset($_GET['search'])) {
                        $SearchField = '%' . $_GET['search'] . '%';
                        $query = "SELECT
            id, video_type, cid, category_name, video_title, description, thumbnail, video_url, share, views, (select count(*) from tbl_comments cm where cm.vid = id) as comments, posted_at, video_status
            FROM tbl_videos
            LEFT JOIN tbl_category c
                ON cid = c.cat_id 
            WHERE video_title LIKE '" . $SearchField . "' ORDER BY id DESC ";
                    } else {
                        $page_limit = 6;

                        $limit = ($_GET['page'] - 1) * $page_limit;

                        $query = "SELECT
            id, video_type, cid, category_name, video_title, description, thumbnail, video_url, share, views, (select count(*) from tbl_comments cm where cm.vid = id) as comments, posted_at, video_status
            FROM tbl_videos
            LEFT JOIN tbl_category c
                ON cid = c.cat_id 
            WHERE video_status = '1' ORDER BY id DESC LIMIT $limit, $page_limit";
                    }

                    $stmt = $mysqli->prepare($query);
                    $stmt->execute();
                    $stmt->bind_result($id, $videos_type, $cid, $category_name, $video_title, $description, $thumbnail, $video_url, $share, $views, $comments, $posted_at, $video_status);

                    while ($stmt->fetch()) {
                        $data = array();
                        $data['id'] = $id;
                        $data['video_type'] = $videos_type;
                        $data['cid'] = $cid;
                        $data['category_name'] = $category_name;
                        $data['video_title'] = stripslashes($video_title);
                        $data['description'] = $description;
                        $data['thumbnail'] = $imagepath . 'images/' . $thumbnail;
                        $data['video_url'] = $video_url;
                        $data['share'] = thousandsNumberFormat($share);
                        $data['views'] = thousandsNumberFormat($views);
                        $data['comments'] = thousandsNumberFormat($comments);
                        $data['posted_at'] = time_ago_full(date('d-m-Y H:i:s', $posted_at));
                        $data['video_status'] = $video_status;
                        array_push($response, $data);
                    }
                    break;

                case 'updateNewsViews':
                    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
                        $viewsget = getById("tbl_news", $_POST['id']);
                        $views = $viewsget['views'];
                        $views++;
                        $id = $_POST['id'];

                        $Sql_Query = "UPDATE tbl_news SET views = '$views' WHERE id = $id";

                        if (mysqli_query($mysqli, $Sql_Query)) {
                            $data['error'] = false;
                            $data['message'] = 'Record Updated Successfully';
                        } else {
                            $data['error'] = true;
                            $data['message'] = 'View Update Failed';
                        }
                    }
                    array_push($response, $data);
                    mysqli_close($mysqli);
                    break;

                case 'updateNewsShare':
                    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
                        $sharesget = getById("tbl_news", $_POST['id']);
                        $shares = $sharesget['share'];
                        $shares++;
                        $id = $_POST['id'];

                        $Sql_Query = "UPDATE tbl_news SET share = '$shares' WHERE id = $id";

                        if (mysqli_query($mysqli, $Sql_Query)) {
                            $data['error'] = false;
                            $data['message'] = 'Record Updated Successfully';
                        } else {
                            $data['error'] = true;
                            $data['message'] = 'Record Update Failed';
                        }
                    }
                    array_push($response, $data);
                    mysqli_close($mysqli);
                    break;

                case 'updateVideosShare':
                    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
                        $sharesget = getById("tbl_videos", $_POST['id']);
                        $shares = $sharesget['share'];
                        $shares++;
                        $id = $_POST['id'];

                        $Sql_Query = "UPDATE tbl_videos SET share = '$shares' WHERE id = $id";

                        if (mysqli_query($mysqli, $Sql_Query)) {
                            $data['error'] = false;
                            $data['message'] = 'Record Updated Successfully';
                        } else {
                            $data['error'] = true;
                            $data['message'] = 'Record Update Failed';
                        }
                    }
                    array_push($response, $data);
                    mysqli_close($mysqli);
                    break;

                case 'updateVideoViews':
                    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
                        $viewsget = getById("tbl_videos", $_POST['id']);
                        $views = $viewsget['views'];
                        $views++;
                        $id = $_POST['id'];

                        $Sql_Query = "UPDATE tbl_videos SET views = '$views' WHERE id = $id";

                        if (mysqli_query($mysqli, $Sql_Query)) {
                            $data['error'] = false;
                            $data['message'] = 'Record Updated Successfully';
                        } else {
                            $data['error'] = true;
                            $data['message'] = 'View Update Failed';
                        }
                    }
                    array_push($response, $data);
                    mysqli_close($mysqli);
                    break;

                case 'report':
                    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
                        $type = $_POST['type'];
                        $uid = $_POST['uid'];
                        $nid = $_POST['nid'];
                        $vid = $_POST['vid'];
                        $report = $_POST['report'];
                        $created = strtotime(date('d-m-Y h:i:s A'));

                        $Sql_Query = "INSERT INTO tbl_reports (type, uid, nid, vid, report, created) VALUES ('" . $type . "', '" . $uid . "', '" . $nid . "', '" . $vid . "', '" . $report . "', '" . $created . "')";

                        if (mysqli_query($mysqli, $Sql_Query)) {
                            $data['error'] = false;
                            $data['message'] = 'Report Submitted Successfully';
                        } else {
                            $data['error'] = true;
                            $data['message'] = 'Report Submit Failed';
                        }
                    }
                    array_push($response, $data);
                    mysqli_close($mysqli);
                    break;

                case 'addComment':
                    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
                        $type = $_POST['type'];
                        $uid = $_POST['uid'];
                        $nid = $_POST['nid'];
                        $vid = $_POST['vid'];
                        $comment = $_POST['comment'];
                        $created = strtotime(date('d-m-Y h:i:s A'));

                        $Sql_Query = "INSERT INTO tbl_comments (type, uid, nid, vid, comment, created) VALUES ('" . $type . "', '" . $uid . "', '" . $nid . "', '" . $vid . "', 
                    '" . $comment . "', '" . $created . "')";

                        if (mysqli_query($mysqli, $Sql_Query)) {
                            $data['error'] = false;
                            $data['message'] = 'Comment Submitted Successfully';
                        } else {
                            $data['error'] = true;
                            $data['message'] = 'Comment Submit Failed';
                        }
                    }
                    array_push($response, $data);
                    mysqli_close($mysqli);
                    break;

                case 'comments':
                    $type = $_GET['type'];
                    $post_id = $_GET['post_id'];
                    if ($type == "news") {
                        $query = "SELECT cmt_id, type, uid, name, img_url, nid, vid, comment, created, cmt_status FROM tbl_comments cmt
                    LEFT JOIN tbl_users u ON cmt.uid = u.user_id 
                    WHERE cmt.nid = $post_id AND cmt_status = 1 AND u.status = 1";
                    } else if ($type == "video") {
                        $query = "SELECT cmt_id, type, uid, name, img_url, nid, vid, comment, created, cmt_status FROM tbl_comments cmt
                    LEFT JOIN tbl_users u ON cmt.uid = u.user_id 
                    WHERE cmt.vid = $post_id AND cmt_status = 1 AND u.status = 1";
                    }
                    $stmt = $mysqli->prepare($query);
                    $stmt->execute();
                    $stmt->bind_result($cmt_id, $type, $uid, $name, $img_url, $nid, $vid, $comment, $created, $cmt_status);

                    while ($stmt->fetch()) {
                        $data = array();
                        $data['cmt_id'] = $cmt_id;
                        $data['type'] = $type;
                        $data['uid'] = $uid;
                        $data['user_name'] = $name;
                        $data['user_img'] = $imagepath . 'images/profile/' . $img_url;
                        $data['nid'] = $nid;
                        $data['vid'] = $vid;
                        $data['comment'] = $comment;
                        $data['created'] = time_ago_small(date('d-m-Y H:i:s', $created));
                        $data['cmt_status'] = $cmt_status;
                        array_push($response, $data);
                    }

                    break;

                case 'addNews':
                    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
                        $news_type = $_POST['news_type'];
                        $cid = $_POST['cid'];
                        $uid = $_POST['uid'];
                        $news_title = addslashes(trim($_POST['news_title']));
                        $news = $_POST['news'];
                        $thumbnail = $_POST['thumbnail'];
                        $video_url = $_POST['video_url'];
                        $posted_at = strtotime(date('d-m-Y h:i:s A'));
                        $news_status = $_POST['news_status'];

                        $file = $_FILES['thumbnail']['tmp_name'];
                        $sourceProperties = getimagesize($file);
                        $ext = pathinfo($_FILES['thumbnail']['name'], PATHINFO_EXTENSION);
                        $imageType = $sourceProperties[2];
                        $fileNewName = "news_" . $_POST['uid'] . rand(1, 100);
                        $folderPath = $newsTarget_dir;
                        $uploadedFile = $newsTarget_dir . $fileNewName . "." . $ext;


                        switch ($imageType) {

                            case IMAGETYPE_PNG:
                                $imageResourceId = imagecreatefrompng($file);
                                $targetLayer = imageResizeNews($imageResourceId, $sourceProperties[0], $sourceProperties[1]);
                                imagepng($targetLayer, $folderPath . $fileNewName . "." . $ext);
                                break;


                            case IMAGETYPE_GIF:
                                $imageResourceId = imagecreatefromgif($file);
                                $targetLayer = imageResizeNews($imageResourceId, $sourceProperties[0], $sourceProperties[1]);
                                imagegif($targetLayer, $folderPath . $fileNewName . "." . $ext);
                                break;

                            case IMAGETYPE_JPEG:
                                $imageResourceId = imagecreatefromjpeg($file);
                                $targetLayer = imageResizeNews($imageResourceId, $sourceProperties[0], $sourceProperties[1]);
                                imagejpeg($targetLayer, $folderPath . $fileNewName . "." . $ext);
                                break;

                            case IMAGETYPE_JPG:
                                $imageResourceId = imagecreatefromjpeg($file);
                                $targetLayer = imageResizeNews($imageResourceId, $sourceProperties[0], $sourceProperties[1]);
                                imagejpeg($targetLayer, $folderPath . $fileNewName . "." . $ext);
                                break;

                            default:
                                echo "Invalid Image type.";
                                exit;
                                break;
                        }
                        move_uploaded_file($fileNewName . "." . $ext, $folderPath);
                        $target = $fileNewName . "." . $ext;

                        $Sql_Query = "INSERT INTO tbl_news (news_type, cid, uid, news_title, news, thumbnail, video_url, posted_at, news_status) VALUES ('" . $news_type . "', '" . $cid . "', '" . $uid . "',  '" . $news_title . "', '" . $news . "', '" . $target . "', '" . $video_url . "', '" . $posted_at . "', '" . $news_status . "')";

                        if (mysqli_query($mysqli, $Sql_Query)) {
                            $data['error'] = false;
                            $data['message'] = 'News Added Successfully';
                        } else {
                            $data['error'] = true;
                            $data['message'] = 'News Update Failed';
                        }
                    }
                    array_push($response, $data);
                    mysqli_close($mysqli);
                    break;

                case 'updateNews':
                    if (isTheseParametersAvailable(array('id', 'news_type', 'cid', 'uid', 'news_title', 'news', 'news_status'))) {
                        $id = $_POST['id'];
                        $news_type = $_POST['news_type'];
                        $cid = $_POST['cid'];
                        $uid = $_POST['uid'];
                        $news_title = addslashes(trim($_POST['news_title']));
                        $news = $_POST['news'];
                        $thumbnail = $_POST['thumbnail'];
                        $video_url = $_POST['video_url'];
                        $news_status = $_POST['news_status'];

                        if (isset($_FILES['thumbnail']['name'])) {
                            $file = $_FILES['thumbnail']['tmp_name'];
                            $sourceProperties = getimagesize($file);
                            $ext = pathinfo($_FILES['thumbnail']['name'], PATHINFO_EXTENSION);
                            $imageType = $sourceProperties[2];
                            $fileNewName = "news_" . $_POST['id'];
                            $folderPath = $target_dir;
                            $uploadedFile = $target_dir . $fileNewName . "." . $ext;


                            switch ($imageType) {

                                case IMAGETYPE_PNG:
                                    $imageResourceId = imagecreatefrompng($file);
                                    $targetLayer = imageResizeNews($imageResourceId, $sourceProperties[0], $sourceProperties[1]);
                                    imagepng($targetLayer, $folderPath . $fileNewName . "." . $ext);
                                    break;


                                case IMAGETYPE_GIF:
                                    $imageResourceId = imagecreatefromgif($file);
                                    $targetLayer = imageResizeNews($imageResourceId, $sourceProperties[0], $sourceProperties[1]);
                                    imagegif($targetLayer, $folderPath . $fileNewName . "." . $ext);
                                    break;

                                case IMAGETYPE_JPEG:
                                    $imageResourceId = imagecreatefromjpeg($file);
                                    $targetLayer = imageResizeNews($imageResourceId, $sourceProperties[0], $sourceProperties[1]);
                                    imagejpeg($targetLayer, $folderPath . $fileNewName . "." . $ext);
                                    break;

                                case IMAGETYPE_JPG:
                                    $imageResourceId = imagecreatefromjpeg($file);
                                    $targetLayer = imageResizeNews($imageResourceId, $sourceProperties[0], $sourceProperties[1]);
                                    imagejpeg($targetLayer, $folderPath . $fileNewName . "." . $ext);
                                    break;

                                default:
                                    echo "Invalid Image type.";
                                    exit;
                                    break;
                            }
                            move_uploaded_file($fileNewName . "." . $ext, $folderPath);
                            $target = $fileNewName . "." . $ext;

                            //saving the uploaded file to the uploads directory in our target file

                            $query = "UPDATE `tbl_news` SET `news_type` = ?, `cid` = ?, `uid` = ?,`news_title` = ?, `news` = ?, `thumbnail` = ?, `video_url` = ?, `news_status` = ? WHERE `id` = ?";
                            $stmt = $mysqli->prepare($query);
                            $stmt->bind_param("siissssii", $_POST['news_type'], $_POST['cid'], $_POST['uid'], $_POST['news_title'], $_POST['news'], $target, $_POST['video_url'], $_POST['news_status'], $_POST['id']);
                        } else {

                            $query = "UPDATE `tbl_news` SET `news_type` = ?, `cid` = ?, `uid` = ?,`news_title` = ?, `news` = ?, `video_url` = ?, `news_status` = ? WHERE `id` = ?";
                            $stmt = $mysqli->prepare($query);
                            $stmt->bind_param("siisssii", $_POST['news_type'], $_POST['cid'], $_POST['uid'], $_POST['news_title'], $_POST['news'], $_POST['video_url'], $_POST['news_status'], $_POST['id']);
                        }

                        //if it is saved in database successfully
                        if ($stmt->execute()) {
                            //displaying success response
                            $data['error'] = false;
                            $data['message'] = 'News Updated Successfully';
                        } else {
                            //if not saved in database
                            //showing response accordingly
                            $data['error'] = true;
                            $data['message'] = 'Could not update, please try again...';
                        }
                        $stmt->close();
                        //in case we have an error in validation, displaying the error message
                    } else {
                        $data['error'] = true;
                        $data['message'] = $message . " is required.";
                    }
                    array_push($response, $data);
                    mysqli_close($mysqli);
                    break;

                    case 'settings':

                    $pm_query = "SELECT payment_method FROM tbl_payment_methods";
                    $pm_result = $mysqli->query($pm_query);
                    $payment_methods = array();
                    while ($row = $pm_result->fetch_array()) {
                        $payment_methods[] = $row['payment_method'];
                    }

                    $query = "SELECT app_update_status, app_new_version, app_update_desc, app_redirect_url, ad_status, inter_clicks, ad_network, admob_small_banner, admob_medium_banner, admob_inter, admob_native, 
                        facebook_small_banner, facebook_medium_banner, facebook_inter, facebook_native,
                        applovin_small_banner, applovin_medium_banner, applovin_inter, applovin_native, startapp_app_id, news_reward_status, redeem_points, redeem_amount, redeem_currency, minimum_redeem_points, news_seconds, news_reward, facebook_username, facebook_id, instagram_username, twitter_username, telegram_username, youtube_username, facebook_status, instagram_status, twitter_status, telegram_status, youtube_status, about_us_contact, about_us_email, about_us_developer, about_us_description FROM tbl_settings LEFT JOIN tbl_ads_settings ad ON id = ad.ad_id";

                    $stmt = $mysqli->prepare($query);
                        
                    $data = array();
                    
                    if ($stmt) {
                        
                    $data = array();
                    if($stmt->execute()){
                        $stmt->bind_result($app_update_status, $app_new_version, $app_update_desc, $app_redirect_url, $ad_status, $inter_clicks, $ad_network, $admob_small_banner, $admob_medium_banner, $admob_inter, $admob_native, $applovin_small_banner,  $facebook_small_banner, $facebook_medium_banner, $facebook_inter, $facebook_native, $applovin_medium_banner, $applovin_inter, $applovin_native, $startapp_app_id, $news_reward_status, $redeem_points, $redeem_amount, $redeem_currency, $minimum_redeem_points, $news_seconds, $news_reward, $facebook_username, $facebook_id, $instagram_username, $twitter_username, $telegram_username, $youtube_username, $facebook_status, $instagram_status, $twitter_status, $telegram_status, $youtube_status, $about_us_contact, $about_us_email, $about_us_developer, $about_us_description);

                    while ($stmt->fetch()) {
                        $data['error'] = false;
                        $data['message'] = "Data Available";
                        $data['app_update_status'] = $app_update_status;
                        $data['app_new_version'] = $app_new_version;
                        $data['app_update_desc'] = $app_update_desc;
                        $data['app_redirect_url'] = $app_redirect_url;
                        $data['ad_status'] = $ad_status;
                        $data['inter_clicks'] = $inter_clicks;
                        $data['ad_network'] = $ad_network;
                        $data['admob_small_banner'] = $admob_small_banner;
                        $data['admob_medium_banner'] = $admob_medium_banner;
                        $data['admob_inter'] = $admob_inter;
                        $data['admob_native'] = $admob_native;
                        $data['facebook_small_banner'] = $facebook_small_banner;
                        $data['facebook_medium_banner'] = $facebook_medium_banner;
                        $data['facebook_inter'] = $facebook_inter;
                        $data['facebook_native'] = $facebook_native;
                        $data['applovin_small_banner'] = $applovin_small_banner;
                        $data['applovin_medium_banner'] = $applovin_medium_banner;
                        $data['applovin_inter'] = $applovin_inter;
                        $data['applovin_native'] = $applovin_native;
                        $data['startapp_app_id'] = $startapp_app_id;
                        $data['news_reward_status'] = $news_reward_status;
                        $data['redeem_points'] = $redeem_points;
                        $data['redeem_amount'] = $redeem_amount;
                        $data['redeem_currency'] = $redeem_currency;
                        $data['minimum_redeem_points'] = $minimum_redeem_points;
                        $data['news_seconds'] = $news_seconds;
                        $data['news_reward'] = $news_reward;
                        $data['reward_format'] = getRewardFormat($redeem_points, $redeem_amount);
                        $data['payment_methods'] = $payment_methods;
                        $data['facebook_username'] = $facebook_username;
                        $data['facebook_id'] = $facebook_id;
                        $data['instagram_username'] = $instagram_username;
                        $data['twitter_username'] = $twitter_username;
                        $data['telegram_username'] = $telegram_username;
                        $data['youtube_username'] = $youtube_username;
                        $data['facebook_status'] = $facebook_status;
                        $data['instagram_status'] = $instagram_status;
                        $data['twitter_status'] = $twitter_status;
                        $data['telegram_status'] = $telegram_status;
                        $data['youtube_status'] = $youtube_status;
                        $data['about_us_contact'] = $about_us_contact;
                        $data['about_us_email'] = $about_us_email;
                        $data['about_us_developer'] = $about_us_developer;
                        $data['about_us_description'] = $about_us_description;
                    }
                    }
                    else {
                        $data['error'] = true;
                        $data['message'] = "Something went wrong!";
                    }
                    } else {
                        $data['error'] = true;
                        $data['message'] = "Something went wrong!";
                    }
                    array_push($response, $data);

                    break;

                case 'addRemoveFav':
                    $type = "news";
                    $user_id = $_POST['user_id'];
                    $post_id = $_POST['post_id'];
                    $created_at = strtotime(date('d-m-Y h:i:s A'));

                    $stmt = $mysqli->prepare("SELECT * FROM tbl_favorites WHERE type = ? AND user_id = ? AND post_id = ?");
                    $stmt->bind_param("sii", $type, $user_id, $post_id);
                    $stmt->execute();
                    $stmt->store_result();
                    if ($stmt->num_rows == 0) {
                        $stmt = $mysqli->prepare("INSERT INTO tbl_favorites (type, user_id, post_id, created_at) VALUES (?, ?, ?, ?)");
                        $stmt->bind_param("siii", $type, $user_id, $post_id, $created_at);

                        //if the user is successfully added to the database 
                        if ($stmt->execute()) {
                            $data['error'] = false;
                            $data['message'] = 'Favorite Inserted Successfully';
                        } else {
                            $data['error'] = true;
                            $data['message'] = 'Favorite Add Failed';
                        }
                    } else {
                        $stmt = $mysqli->prepare("DELETE FROM tbl_favorites WHERE type = ? AND user_id = ? AND post_id = ?");
                        $stmt->bind_param("sii", $type, $user_id, $post_id);

                        //if the user is successfully added to the database 
                        if ($stmt->execute()) {
                            $data['error'] = false;
                            $data['message'] = 'Favorite Deleted Successfully';
                        } else {
                            $data['error'] = true;
                            $data['message'] = 'Favorite Delete Failed';
                        }
                    }
                    $stmt->close();
                    array_push($response, $data);
                    mysqli_close($mysqli);
                    break;

                case 'addPoints':
                    $user_id = $_POST['user_id'];
                    $post_id = $_POST['post_id'];
                    $activity = $_POST['activity'];
                    $points = $settings['news_reward'];
                    $created_at = strtotime(date('d-m-Y h:i:s A'));

                    $stmt = $mysqli->prepare("INSERT INTO tbl_earnings (user_id, post_id, activity, points, created_at) VALUES (?, ?, ?, ?, ?)");
                    $stmt->bind_param("iisii", $user_id, $post_id, $activity, $points, $created_at);

                    //if the user is successfully added to the database 
                    if ($stmt->execute()) {
                        $data['error'] = false;
                        $data['message'] = 'Points Inserted Successfully';
                    } else {
                        $data['error'] = true;
                        $data['message'] = 'Points Insert Failed';
                    }

                    $stmt->close();
                    array_push($response, $data);
                    mysqli_close($mysqli);
                    break;

                case 'earnHistory':
                    $uid = $_GET['user_id'];
                    $query = "SELECT e_id, post_id, user_id, points, created_at, news_title, activity, status FROM tbl_earnings e LEFT JOIN tbl_news n ON post_id = n.id WHERE user_id = $uid ORDER BY e_id DESC";

                    $stmt = $mysqli->prepare($query);
                    $stmt->execute();
                    $stmt->bind_result($e_id, $post_id, $user_id, $points, $created_at, $news_title, $activity, $status);

                    while ($stmt->fetch()) {
                        $data = array();
                        $data['e_id'] = $e_id;
                        $data['post_id'] = $post_id;
                        $data['user_id'] = $user_id;
                        $data['points'] = $points;
                        $data['created_at'] = time_ago_small(date('d-m-Y H:i:s', $created_at));
                        $data['news_title'] = $news_title;
                        $data['activity'] = $activity;
                        $data['status'] = $status;
                        array_push($response, $data);
                    }

                    break;

                case 'withdrawalHistory':
                    $uid = $_GET['user_id'];
                    $query = "SELECT * FROM tbl_transactions WHERE uid = $uid ORDER BY id DESC";

                    $stmt = $mysqli->prepare($query);
                    $stmt->execute();
                    $stmt->bind_result($id, $uid, $payment_method, $payment_detail, $points, $amount, $created_at, $remarks, $payment_status);

                    while ($stmt->fetch()) {
                        $data = array();
                        $data['id'] = $id;
                        $data['uid'] = $uid;
                        $data['payment_method'] = $payment_method;
                        $data['payment_detail'] = $payment_detail;
                        $data['points'] = $points;
                        $data['amount'] = CURRENCY . " " . $amount;
                        $data['created_at'] = time_ago_full(date('d-m-Y H:i:s', $created_at));
                        $data['remarks'] = $remarks;
                        $data['payment_status'] = $payment_status;
                        array_push($response, $data);
                    }

                    break;

                case 'getUserPoints':
                    $GET_ID = $_GET['uid'];
                    $data = array();
                    if (get_available_points($GET_ID) == "") {
                        $data['points'] = 0;
                    } else {
                        $data['points'] = get_available_points($GET_ID);
                    }
                    array_push($response, $data);
                    break;

                case 'redeem':
                    $uid = $_POST['uid'];
                    $points = $_POST['points'];
                    //$amount = $_POST['amount'];
                    $amount = $points/getRewardFormat($settings_details['redeem_points'],$settings_details['redeem_amount']);
                    $amount = round($amount,2);
                    $payment_method = $_POST['payment_method'];
                    $payment_detail = $_POST['payment_detail'];
                    $created_at = strtotime(date('d-m-Y h:i:s A'));
                    $status = '2';
                    $remark = "No info available, please check after sometime.";

                    /*$points_query = "SELECT e_id FROM tbl_earnings WHERE user_id = '" . $uid . "' ";
                    $points_result = $mysqli->query($points_query);
                    $earning_ids = array();
                    while ($row = $points_result->fetch_array()) {
                        $earning_ids[] = $row['e_id'];
                    }*/

                    $stmt = $mysqli->prepare("INSERT INTO tbl_transactions (uid, points, amount, payment_method, payment_detail, remark, created_at) VALUES (?, ?, ?, ?, ?, ?, ?)");
                    $stmt->bind_param("iidsssi", $uid, $points, $amount, $payment_method, $payment_detail, $remark, $created_at);

                    //if the user is successfully added to the database 
                    if ($stmt->execute()) {
                        $query = "UPDATE tbl_earnings SET status = ? WHERE user_id = ?";
                        $stmt = $mysqli->prepare($query);
                        $stmt->bind_param("ii", $status, $uid);
                        if ($stmt->execute()) {
                            $data['error'] = false;
                            $data['message'] = 'Points Redeem Successfully';
                        } else {
                            $data['error'] = true;
                            $data['message'] = 'Points Redeem Failed';
                        }
                    } else {
                        $data['error'] = true;
                        $data['message'] = 'Points Redeem Failed';
                    }

                    $stmt->close();
                    array_push($response, $data);
                    mysqli_close($mysqli);

                    break;

                case 'contactform':
                    $name = $_POST['name'];
                    $email = $_POST['email'];
                    $subject = $_POST['subject'];
                    $message = $_POST['message'];
                    $created_at = strtotime(date('d-m-Y h:i:s A'));

                    $stmt = $mysqli->prepare("INSERT INTO tbl_contacts (name, email, subject, message, created_at) VALUES (?, ?, ?, ?, ?)");
                    $stmt->bind_param("ssssi", $name, $email, $subject, $message, $created_at);

                    //if the user is successfully added to the database 
                    if ($stmt->execute()) {
                        $data['error'] = false;
                        $data['message'] = "Contact form submitted successfully, We'll get back to you soon..";
                    } else {
                        $data['error'] = true;
                        $data['message'] = 'Contact form submission failed, Please try again!';
                    }

                    $stmt->close();
                    array_push($response, $data);
                    mysqli_close($mysqli);
                    break;


                default:
                    $response['error'] = true;
                    $response['message'] = 'Invalid Operation Called';
            }
        }
    } else {
        $data['error'] = true;
        $data['message'] = 'Invalid Api Key';
    array_push($response, $data);
    }
} else {
    $data['error'] = true;
    $data['message'] = 'Invalid Purchase Code or Package Name';
    array_push($response, $data);
}

function getBaseURL2()
{
    $url = isset($_SERVER['HTTPS']) ? 'https://' : 'http://';
    $url .= $_SERVER['SERVER_NAME'];
    $url .= $_SERVER['REQUEST_URI'];
    return dirname($url) . '/';
}

function isTheseParametersAvailable($params)
{

    //traversing through all the parameters 
    foreach ($params as $param) {
        //if the paramter is not available
        if (!isset($_POST[$param])) {
            //return false 
            return false;
        }
    }
    //return true if every param is available 
    return true;
}

function generateRandomPassword($length = 10)
{
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}

function imageResize($imageResourceId, $width, $height)
{

    $targetWidth = 512;
    $targetHeight = $height / $width * $targetWidth;

    $targetLayer = imagecreatetruecolor($targetWidth, $targetHeight);
    imagecopyresampled($targetLayer, $imageResourceId, 0, 0, 0, 0, $targetWidth,   $targetHeight, $width, $height);

    return $targetLayer;
}

function imageResizeNews($imageResourceId, $width, $height)
{

    $targetWidth = 786;
    $targetHeight = $height / $width * $targetWidth;

    $targetLayer = imagecreatetruecolor($targetWidth, $targetHeight);
    imagecopyresampled($targetLayer, $imageResourceId, 0, 0, 0, 0, $targetWidth,   $targetHeight, $width, $height);

    return $targetLayer;
}

function is_favorite($post_id, $uid)
{
    global $mysqli;

    $qry = "SELECT * FROM tbl_favorites WHERE  user_id = '$uid' AND post_id = '$post_id'";
    $result = mysqli_query($mysqli, $qry);
    $row = mysqli_fetch_assoc($result);

    if (mysqli_num_rows($result) > 0) {
        return true;
    } else {
        return false;
    }
}

if (isset($_GET['do']) == "verify") {
    $code = $_GET['pcode'];
    $code = trim($code);
    verify_envato_purchase_code($code);
}

function getRewardFormat($points, $amount)
{
    $reward_format = $points / $amount;

    return round($reward_format, 2);
}

function get_available_points($user_id)
{
    global $mysqli;
    $qry_get_points = "SELECT * FROM tbl_earnings WHERE status = 0 AND user_id = '" . $user_id . "' ";
    $points_result = $mysqli->query($qry_get_points);
    $total_available_points = array();
    while ($rows = $points_result->fetch_array()) {
        $total_available_points[] = $rows['points'];
    }

    return array_sum($total_available_points);
}



header('Content-Type: application/json; charset=utf-8');
echo $response = str_replace('\\/', '/', json_encode($response, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
