<?php
include("includes/connection.php");
include("includes/session_check.php");
$currentURL = $_SERVER["SCRIPT_NAME"];
$parts = Explode('/', $currentURL);
$currentURL = $parts[count($parts) - 1];

include("includes/data.php");
$settings = getById("tbl_settings", "1"); ?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
    <title><?php echo $settings['app_name'] ?></title>
    <!-- General CSS Files -->
    <link rel="stylesheet" href="assets/css/app.min.css">
    <link rel="stylesheet" href="assets/bundles/datatables/datatables.min.css">
    <link rel="stylesheet" href="assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/bundles/select2/dist/css/select2.min.css">
    <link rel="stylesheet" href="assets/bundles/summernote/summernote-bs4.css">
    <link rel="stylesheet" href="assets/bundles/jquery-selectric/selectric.css">
    <link rel="stylesheet" href="assets/bundles/codemirror/theme/duotone-dark.css">
    <link rel="stylesheet" href="assets/bundles/chocolat/dist/css/chocolat.css">
    <link rel="stylesheet" href="assets/bundles/pretty-checkbox/pretty-checkbox.min.css">
    <!-- Template CSS -->
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/components.css">
    <!-- Custom style CSS -->
    <link rel="stylesheet" href="assets/css/custom.css">
    <link rel="stylesheet" type="text/css" href="assets/duDialog-master/duDialog.min.css">

    <script src="assets/ckeditor/ckeditor.js"></script>

</head>

<body>
    <div id="app">
        <div class="main-wrapper main-wrapper-1">
            <div class="navbar-bg"></div>
            <nav class="navbar navbar-expand-lg main-navbar sticky">
                <div class="form-inline mr-auto">
                    <ul class="navbar-nav mr-3">
                        <li><a href="#" data-toggle="sidebar" class="nav-link nav-link-lg collapse-btn"> <i data-feather="align-justify"></i></a></li>
                        <li>
                        </li>
                    </ul>
                </div>
                <ul class="navbar-nav navbar-right">

                    <li class="dropdown"><a href="#" data-toggle="dropdown" class="nav-link dropdown-toggle nav-link-lg nav-link-user"> <img alt="image" src="assets/img/user2.png" class="user-img-radious-style"> <span class="d-sm-none d-lg-inline-block"></span></a>
                        <div class="dropdown-menu dropdown-menu-right pullDown">
                            <div class="dropdown-title">Hello <?php echo $_SESSION['name'] ?></div>
                            <a href="edit-profile" class="dropdown-item has-icon"> <i class="fas fa-cog"></i>
                                Settings
                            </a>
                            <div class="dropdown-divider"></div>
                            <a href="logout" class="dropdown-item has-icon text-danger"> <i class="fas fa-sign-out-alt"></i>
                                Logout
                            </a>
                        </div>
                    </li>
                </ul>
            </nav>
            <div class="main-sidebar sidebar-style-2">
                <aside id="sidebar-wrapper">
                    <div class="sidebar-brand">


                        <a href="index">
                            <img alt="image" src="images/<?php echo $settings['app_logo'] ?>" class="header-logo" />
                            <br>
                            <span class="logo-name"><?php echo $settings['app_name'] ?></span>
                        </a>
                    </div>
                    <ul class="sidebar-menu">
                        <li <?php if ($currentURL == "home.php") { ?>class="active" <?php } ?>> <a href="home" class="nav-link"><i class="fa fa-home" aria-hidden="true"></i><span>Dashboard</span></a>
                        </li>

                        <li <?php if ($currentURL == "manage-category.php" or $currentURL == "add-category.php") { ?>class="active" <?php } ?>> <a href="manage-category" class="nav-link"><i class="fa fa-sitemap" aria-hidden="true"></i><span>Categories</span></a>
                        </li>

                        <li <?php if ($currentURL == "manage-news.php" or $currentURL == "add-news.php") { ?>class="active" <?php } ?>> <a href="manage-news" class="nav-link"><i class="fa fa-newspaper" aria-hidden="true"></i><span>News</span></a>
                        </li>

                        <li <?php if ($currentURL == "news-approval.php") { ?>class="active" <?php } ?>> <a href="news-approval" class="nav-link"><i class="fa fa-newspaper" aria-hidden="true"></i><span>News Approval</span></a>
                        </li>

                        <li <?php if ($currentURL == "manage-videos.php" or $currentURL == "add-video.php") { ?>class="active" <?php } ?>> <a href="manage-videos" class="nav-link"><i class="fa fa-video" aria-hidden="true"></i><span>Videos</span></a>
                        </li>

                        <li <?php if ($currentURL == "manage-users.php" or $currentURL == "user-profile.php") { ?>class="active" <?php } ?>> <a href="manage-users" class="nav-link"><i class="fa fa-user" aria-hidden="true"></i><span>Users</span></a>
                        </li>

                        <li <?php if ($currentURL == "manage-transactions.php") { ?>class="active" <?php } ?>> <a href="manage-transactions" class="nav-link"><i class="fa fa-list" aria-hidden="true"></i><span>Transactions</span></a>
                        </li>

                        <li <?php if ($currentURL == "manage-comments.php") { ?>class="active" <?php } ?>> <a href="manage-comments" class="nav-link"><i class="fa fa-comments" aria-hidden="true"></i><span>Comments</span></a>
                        </li>
                        
                        <li <?php if ($currentURL == "manage-contact-forms.php") { ?>class="active" <?php } ?>> <a href="manage-contact-forms" class="nav-link"><i class="fa fa-envelope" aria-hidden="true"></i><span>Contact Forms</span></a>
                        </li>

                        <li <?php if ($currentURL == "manage-reports.php") { ?>class="active" <?php } ?>> <a href="manage-reports" class="nav-link"><i class="fa fa-flag" aria-hidden="true"></i><span>Reports</span></a>
                        </li>

                        <li <?php if ($currentURL == "manage-admin.php" or $currentURL == "add-admin.php") { ?>class="active" <?php } ?>> <a href="manage-admin" class="nav-link"><i class="fa fa-id-badge" aria-hidden="true"></i><span>Administrators</span></a>
                        </li>

                        <li <?php if ($currentURL == "send-notification.php") { ?>class="active" <?php } ?>> <a href="send-notification" class="nav-link"><i class="fa fa-bell" aria-hidden="true"></i><span>Send Notification</span></a>
                        </li>

                        <li <?php if ($currentURL == "app-update.php") { ?>class="active" <?php } ?>> <a href="app-update" class="nav-link"><i class="fa fa-upload" aria-hidden="true"></i><span>App Update</span></a>
                        </li>

                        <li class="dropdown <?php if ($currentURL == "smtp-settings.php" or $currentURL == "settings.php" or $currentURL == "reward-points.php" or $currentURL == "add-payment-method.php") { ?>active<?php } ?>">
                            <a href="#" class="menu-toggle nav-link has-dropdown"><i data-feather="settings"></i><span>Settings</span></a>
                            <ul class="dropdown-menu">
                                <li <?php if ($currentURL == "reward-points.php") { ?>class="active" <?php } ?>> <a href="reward-points" class="nav-link"><span>Reward Points</span></a>
                                </li>

                                <li <?php if ($currentURL == "smtp-settings.php") { ?>class="active" <?php } ?>> <a href="smtp-settings" class="nav-link"><span>SMTP Settings</span></a>
                                </li>

                                <li <?php if ($currentURL == "settings.php" or $currentURL == "add-payment-method.php") { ?>class="active" <?php } ?>> <a href="settings?tab=admin" class="nav-link"><span>General Settings</span></a>
                                </li>

                            </ul>
                        </li>

                    </ul>
                </aside>
            </div>
        </div>
    </div>