"use strict"

$(document).ready(function () {
    // Smart Wizard         
    $('#wizard_verticle').smartWizard({
        transitionEffect: 'slideleft',
        onLeaveStep: leaveAStepCallback,
        onFinish: onFinishCallback,
    });

    function leaveAStepCallback(obj) {
        var step_num = obj.attr('rel');
        return validateSteps(step_num);
    }

    function onFinishCallback() {
        if (validateAllSteps()) {
            $('form').submit();
        }
    }

});

function validateAllSteps() {
    var isStepValid = true;
    
    if (validateStep1() == false) {
        isStepValid = false;
        $('#wizard_verticle').smartWizard('setError', {stepnum: 1, iserror: true});
    } else {
        $('#wizard_verticle').smartWizard('setError', {stepnum: 1, iserror: false});
    }

    if (validateStep2() == false) {
        isStepValid = false;
        $('#wizard_verticle').smartWizard('setError', {stepnum: 2, iserror: true});
    } else {
        $('#wizard_verticle').smartWizard('setError', {stepnum: 2, iserror: false});
    }

    if (validateStep3() == false) {
        isStepValid = false;
        $('#wizard_verticle').smartWizard('setError', {stepnum: 3, iserror: true});
    } else {
        $('#wizard_verticle').smartWizard('setError', {stepnum: 3, iserror: false});
    }

    var res = validateStep4();
    if (res.error == true) {
        isStepValid = false;
        $('#wizard_verticle').smartWizard('showMessage', res.message);
        $('#wizard_verticle').smartWizard('setError', {stepnum: 4, iserror: true});
    } else {
        $('#wizard_verticle').smartWizard('hideMessage');
        $('#wizard_verticle').smartWizard('setError', {stepnum: 4, iserror: false});
    }

    if (!isStepValid) {
        $('#wizard_verticle').smartWizard('showMessage', 'Please fill the all required field.!');
    }
    return isStepValid;
}

function validateSteps(step) {
    var isStepValid = true;
    // var minPHPVersion = '7.3';
    // validate step 1
    if (step == 1) {
        if (validateStep1() == false) {
            isStepValid = false;
            $('#wizard_verticle').smartWizard('showMessage', "You must agree to use the license.");
            $('#wizard_verticle').smartWizard('setError', {stepnum: step, iserror: true});
        } else {
            $('#wizard_verticle').smartWizard('hideMessage');
            $('#wizard_verticle').smartWizard('setError', {stepnum: step, iserror: false});
        }
    }
    
    if (step == 2) {
        if (validateStep2() == false) {
            isStepValid = false;
            $('#wizard_verticle').smartWizard('showMessage', "PHP version is not compatible or PHP extensions are missing!");
            $('#wizard_verticle').smartWizard('setError', {stepnum: step, iserror: true});
        } else {
            $('#wizard_verticle').smartWizard('hideMessage');
            $('#wizard_verticle').smartWizard('setError', {stepnum: step, iserror: false});
        }
    }

    // validate step3
    if (step == 3) {
        var res = validateStep3();
        if (res.error == true) {
            isStepValid = false;
            $('#wizard_verticle').smartWizard('showMessage', res.message);
            $('#wizard_verticle').smartWizard('setError', {stepnum: step, iserror: true});
        } else {
            $('#wizard_verticle').smartWizard('hideMessage');
            $('#wizard_verticle').smartWizard('setError', {stepnum: step, iserror: false});
        }
    }

//  validate step4
    if (step == 4) {
        if (validateStep4() == false) {
            isStepValid = false;
            $('#wizard_verticle').smartWizard('showMessage', 'Please correct the errors in step' + step + ' and click next.');
            $('#wizard_verticle').smartWizard('setError', {stepnum: step, iserror: true});
        } else {
            $('#wizard_verticle').smartWizard('hideMessage');
            $('#wizard_verticle').smartWizard('setError', {stepnum: step, iserror: false});
        }
    }

    return isStepValid;
}

function validateStep1() {
    var isValid = true;
    return isValid;
}

function validateStep2() {
    var isValid = true;
    $('#step-2 input').each(function () {
        if ($(this).val() == 0) {
            isValid = false;
        }
    });
    return isValid;
}

function validateStep3() {
    var data = {
        'error': true,
        'message': "Please fill the all required field."
    };
    $('#step-3 input').each(function () {
        if (!$(this).val() && $(this).val().length <= 0) {
            data = {
                'error': true,
                'message': "Please fill the all required field."
            };
        }
    });
    var purchase_code = $("#step-3 input#purchase_code").val();
    var package_name = $("#step-3 input#package_name").val();

    if (purchase_code != "" && package_name != "") {
        data = check_purchase_code(purchase_code, package_name);
    } else {
        data = {
            'error': true,
            'message': "Please fill the all required field."
        };
    }
    return data;
}

function check_purchase_code(purchase_code, package_name) {
    var pathname = 'https://verify.andromob.co.in?type=envato&pcode='+purchase_code+'&package_name='+package_name;

    $.ajaxSetup({async: false,
    dataType: 'json',
    contentType: "application/x-www-form-urlencoded; charset=UTF-8"});
    var returnUserData = null;
    $.post(pathname, function (data) {
        returnUserData = data;
    });
    $.ajaxSetup({async: true});
    return returnUserData;
}

function validateStep4() {
    var data = {
        'error': false,
        'message': ""
    };

    var hostname = $("#step-4 input#hostname").val();
    var database = $("#step-4 input#database").val();
    var username = $("#step-4 input#username").val();
    var password = $("#step-4 input#password").val();

    if (hostname != "" && database != "" && username != "") {
        data = {
            'error': false,
            'message': ""
        };
    } else {
        data = {
            'error': true,
            'message': "Please fill the all required field."
        };
    }

    return data;
}

